/*
 *  linux/arch/arm/mach-jasper/arch.c
 *
 *  Architecture specific fixups.  This is where any
 *  parameters in the params struct are fixed up, or
 *  any additional architecture specific information
 *  is pulled from the params struct.
 */
#include <linux/tty.h>
#include <linux/delay.h>
#include <linux/pm.h>
#include <linux/init.h>

#include <asm/elf.h>
#include <asm/setup.h>
#include <asm/mach-types.h>
#include <asm/mach/arch.h>

extern void jasper_init_irq(void);

#if CONFIG_ARCH_QUASAR
extern void quasar_init(void);

static void __init fixup_jasper(struct machine_desc *desc, struct param_struct *unusd,
	char **cmdline, struct meminfo *mi)
{
	quasar_init();
}
#endif

MACHINE_START(JASPER, "JASPER")
     MAINTAINER("Fabrice Gautier - Sigma Designs Inc.")
     BOOT_MEM(0x01000000, 0x500000, 0x500000)
     INITIRQ(jasper_init_irq)
#if CONFIG_ARCH_QUASAR
     FIXUP(fixup_jasper)
#endif
MACHINE_END


