/*
 *  linux/arch/arm/mach-integrator/irq.c
 *
 *  Copyright (C) 1999 ARM Limited
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <linux/init.h>

#include <asm/hardware.h>
#include <asm/irq.h>
#include <asm/io.h>

#include <asm/mach/irq.h>

static void sc_mask_irq(unsigned int irq)
{
	unsigned long tmp;

// disable and redirect to FIQ

        tmp = __raw_readl(JASPER_INT_CONTROLLER_BASE + INT_INTEN);
        __raw_writel(tmp & (~(1 << irq)), JASPER_INT_CONTROLLER_BASE + INT_INTEN);

	tmp = __raw_readl(JASPER_INT_CONTROLLER_BASE + INT_INTTYPE);
        __raw_writel(tmp | (1 << irq), JASPER_INT_CONTROLLER_BASE + INT_INTTYPE);

}

static void sc_unmask_irq(unsigned int irq)
{
	unsigned long tmp;

// redirect to IRQ and enable
	tmp = __raw_readl(JASPER_INT_CONTROLLER_BASE + INT_INTTYPE);
        __raw_writel(tmp & (~(1 << irq)), JASPER_INT_CONTROLLER_BASE + INT_INTTYPE);

	tmp = __raw_readl(JASPER_INT_CONTROLLER_BASE + INT_INTEN);
        __raw_writel(tmp | (1 << irq) | GLOBAL_INT_ENABLE, JASPER_INT_CONTROLLER_BASE + INT_INTEN);
}

void __init jasper_init_irq(void)
{
	unsigned int i;

	for (i = 0; i < NR_IRQS; i++) {
	        if (((1 << i) && JASPER_SC_VALID_INT) != 0) {
		        irq_desc[i].valid	= 1;
			irq_desc[i].probe_ok	= 1;
			irq_desc[i].mask_ack	= sc_mask_irq;
			irq_desc[i].mask	= sc_mask_irq;
			irq_desc[i].unmask	= sc_unmask_irq;
		}
	}

	/* Disable all interrupts initially. But enable the Global Enable */

	__raw_writel(GLOBAL_INT_ENABLE, JASPER_INT_CONTROLLER_BASE + INT_INTEN);

#ifdef CONFIG_ARCH_QUASAR
	{
		extern void quasar_irq_init(void);
		quasar_init_irq();
	}
#endif
}
