
#ifdef CONFIG_REDBOOT_CONSOLE
#ifdef used_and_not_const_char_pointer
static int redboot_console_read(struct uart_port *port, char *s, u_int count)
{
	unsigned int status;
	int c;
#if DEBUG
	printk("redboot_console_read() called\n");
#endif

	c = 0;
	while (c < count) {
		status = UART_GET_LSR(port);
		if (UART_RX_READY(status)) {
			*s++ = UART_GET_CHAR(port);
			c++;
		} else {
			// nothing more to get, return
			return c;
		}
	}
	// return the count
	return c;
}
#endif

static void redboot_console_write(struct console *co, const char *s, u_int count)
{
	struct uart_port *port = jasper_ports + co->index;
	unsigned int status, old_ier;
	int i;

	/*
	 *	First save the IER then disable the interrupts
	 */
	old_ier = UART_GET_IER(port);
	UART_PUT_IER(port, 0);

	/*
	 *	Now, do each character
	 */
	for (i = 0; i < count; i++) {
		do {
			status = UART_GET_LSR(port);
		} while (!UART_TX_READY(status));
		UART_PUT_CHAR(port, s[i]);
		if (s[i] == '\n') {
			do {
				status = UART_GET_LSR(port);
			} while (!UART_TX_READY(status));
			UART_PUT_CHAR(port, '\r');
		}
	}

	/*
	 *	Finally, wait for transmitter to become empty
	 *	and restore the TCR
	 */
	do {
		status = UART_GET_LSR(port);
	} while (!UART_TX_EMPTY(status));
	UART_PUT_IER(port, old_ier);
}

static kdev_t redboot_console_device(struct console *co)
{
	return MKDEV(REDBOOT_CONSOLE_MAJOR, REDBOOT_CONSOLE_MINOR + co->index);
}

static int redboot_console_wait_key(struct console *co)
{
	struct uart_port *port = jasper_ports + co->index;
	unsigned int status;

	do {
		status = UART_GET_LSR(port);
	} while (!UART_RX_READY(status));
	return UART_GET_CHAR(port);
}

static void __init
redboot_console_get_options(struct uart_port *port, int *baud, int *parity, int *bits)
{
	u_int lcr, quot;
	lcr = UART_GET_LCR(port);

	*parity = 'n';
	if (lcr & JASPER_UART_LCR_PEN) {
		if (lcr & JASPER_UART_LCR_EPS)
			*parity = 'e';
		else
			*parity = 'o';
	}
	*bits = (lcr & JASPER_UART_LCR_WLS) + 5;

	quot = UART_GET_CLKDIV(port);
	//FIXME : "+1" is here to avoid division by 0 errors,
	// need to check what REALLY happens when CLKDIV is set to 0, (disabled the UART or ?)
	*baud = port->uartclk / (16 * quot + 1);
}

static int __init redboot_console_setup(struct console *co, char *options)
{
	struct uart_port *port;
	int baud = 38400;
	int bits = 8;
	int parity = 'n';
	int flow = 'n';

	/*
	 * Check whether an invalid uart number has been specified, and
	 * if so, search for the first available port that does have
	 * console support.
	 */
	port = uart_get_console(jasper_ports, UART_NR, co);

	if (options)
		uart_parse_options(options, &baud, &parity, &bits, &flow);
	else
		jasperuart_console_get_options(port, &baud, &parity, &bits);

	return uart_set_options(port, co, baud, parity, bits, flow);
}

static struct console redboot_console = {
	write:		redboot_console_write,
#ifdef used_and_not_const_char_pointer
	read:		redboot_console_read,
#endif
	device:		redboot_console_device,
	wait_key:	redboot_console_wait_key,
	setup:		redboot_console_setup,
	flags:		CON_PRINTBUFFER,
	index:		-1,
};

void __init redboot_console_init(void)
{
	register_console(&redboot_console);
}

#endif
