/* Linux serial driver for Jasper & Mambo  */


#include <linux/tty.h>

static struct tty_driver *serial_driver;


/*
 * This routine is called whenever a serial port is opened.  It
 * enables interrupts for a serial port, linking in its S structure into
 * the IRQ chain.   It also performs the serial-specific
 * initialization for the tty structure.
 */

int uart_open(struct tty_struct *tty, struct file *filp)
{
}


/*
 * ------------------------------------------------------------
 * uart_close()
 *
 * This routine is called when the serial port gets closed.  First, we
 * wait for the last remaining data to be sent.  Then, we unlink its
 * S structure from the interrupt chain if necessary, and we free
 * that IRQ if nothing is left in the chain.
 * ------------------------------------------------------------
 */
static void uart_close(struct tty_struct *tty, struct file *filp)
{
}

static int uart_write(struct tty_struct *tty, int from_user,
					const unsigned char *buf, int count)
{
}


static void uart_flush_chars(struct tty_struct *tty)
{
}

static int uart_write_room(struct tty_struct *tty)
{
}

static int uart_chars_in_buffer(struct tty_struct *tty)
{
}

static void uart_flush_buffer(struct tty_struct *tty)
{
}

static int uart_ioctl(struct tty_struct *tty, struct file *file,
					unsigned int cmd, unsigned long arg)
{
}

/*
 * ------------------------------------------------------------
 * uart_throttle()
 *
 * This routine is called by the upper-layer tty layer to signal that
 * incoming characters should be throttled.
 * ------------------------------------------------------------
 */
static void uart_throttle(struct tty_struct *tty)
{
}

static void uart_unthrottle(struct tty_struct *tty)
{
}

static void uart_set_termios(struct tty_struct *tty,
	struct termios *old_termios)
{
}

/*
 * ------------------------------------------------------------
 * uart_stop() and uart_start()
 *
 * This routines are called before setting or resetting tty->stopped.
 * They enable or disable transmitter interrupts, as necessary.
 * ------------------------------------------------------------
 */

static void uart_stop(struct tty_struct *tty)
{
}

static void uart_start(struct tty_struct *tty)
{
}

/*
 * uart_hangup() --- called by tty_hangup() when a hangup is signaled.
 */
static void uart_hangup(struct tty_struct *tty)
{
}

static void uart_set_ldisc(struct tty_struct *tty)
{

}


/* uart_jasper_init */
static __init uart_jasper_init(void)
{

	/* ... init the serial driver struct ...*/

	memset(&serial_driver, 0, sizeof(struct tty_driver));

	serial_driver.magic = TTY_DRIVER_MAGIC;
	serial_driver.name = "ttyS";
	serial_driver.major = TTY_MAJOR;
	serial_driver.minor_start = 64;
	serial_driver.num = 2;
	serial_driver.type = TTY_DRIVER_TYPE_SERIAL;
	serial_driver.subtype = SERIAL_TYPE_NORMAL;
	serial_driver.init_termios = tty_std_termios;

	serial_driver.init_termios.c_cflag =
		B9600 | CS8 | CREAD | HUPCL | CLOCAL;
	serial_driver.flags = TTY_DRIVER_REAL_RAW;
	serial_driver.refcount = &serial_refcount;
-->	serial_driver.table = serial_table;
	serial_driver.termios = serial_termios;
	serial_driver.termios_locked = serial_termios_locked;

	serial_driver.open = uart_open;
	serial_driver.close = uart_close;
	serial_driver.write = uart_write;
	serial_driver.flush_chars = uart_flush_chars;
	serial_driver.write_room = uart_write_room;
	serial_driver.chars_in_buffer = uart_chars_in_buffer;
	serial_driver.flush_buffer = uart_flush_buffer;
	serial_driver.ioctl = uart_ioctl;
	serial_driver.throttle = uart_throttle;
	serial_driver.unthrottle = uart_unthrottle;
	serial_driver.set_termios = uart_set_termios;
	serial_driver.stop = uart_stop;
	serial_driver.start = uart_start;
	serial_driver.hangup = uart_hangup;
	serial_driver.set_ldisc = uart_set_ldisc;


	if(tty_register_drvier(&serial_driver))
		panic("Couldn't register serial driver\n");

	/* ... interrupt initialisation ... */
}

module_init(uart_jasper_init);

/* console */

static kdev_t jasper_console_device(struct console *c)
{

	return MKDEV(TTY_MAJOR, 64 + c->index);
}

int jasper_console_setup(void)
{

/* hardware init */
  ...
  return 0;
}


void jasper_console_write (struct console *co, const char *str,
			   unsigned int count)
{

/* test if initialized,
	if not init
*/
/*	if (!atmel_console_initialized) {
		init_console(info);
		uart_init(info);
		info->baud = 9600;
		tx_stop(info->usart);
		rx_stop(info->usart);
		uart_speed(info, 0xffff);
		tx_start(info->usart, info->use_ints);
		rx_start(info->usart, info->use_ints);
	}
*/

/* output */

    	while (count--) {
        	if (*str == '\n')
           		uart_put_char(info,'\r');
        	uart_put_char(info, *str++ );
    	}
}


static struct console jasper_console = {
	name:		"ttyS",
	write:		jasper_console_write,
	read:		NULL,
	device:		jasper_console_device,
	wait_key:	NULL,
	unblank:	NULL,
	setup:		jasper_console_setup,
	flags:		CON_PRINTBUFFER,
	index:		-1,
	cflag:		0,
	next:		NULL
};

void jasper_console_init(void)
{
	register_console(&atmel_driver);
}