/* ide-jasper.c */

/* jasper specific initialization stuff for ide */

#include <linux/init.h>
#include <asm/io.h>
#include <asm/hardware.h>
#include <linux/ide.h>

extern int printk(const char *fmt,...);
extern void ide_setup_dma (ide_hwif_t *hwif, unsigned long dma_base, unsigned int num_ports);

int ide_config_drive_speed (ide_drive_t *drive, byte speed);

void __init jasper_ide_init(void)
{
	ide_hwif_t *hwif;

	//	choose ide over dvd loader (DVD_AV_CONTROL)
	//	write 0x8000 to IDETIM
	outl(0x00, JASPER_DVD_BASE + DVD_AV_CTRL);			//0x00 select IDE over DVD-loader
	outl(0x8000, JASPER_IDE_BASE + IDE_TIM);
	
	// grab hwif,
	hwif = &ide_hwifs[0];
//	ide_config_drive_speed (&hwif->drives[0], XFER_MW_DMA_0);
//	ide_config_drive_speed (&hwif->drives[0], XFER_MW_DMA_1);
//	ide_config_drive_speed (&hwif->drives[0], XFER_MW_DMA_2);
//	ide_config_drive_speed (&hwif->drives[0], XFER_UDMA_0);
//	ide_config_drive_speed (&hwif->drives[0], XFER_UDMA_1);
//	ide_config_drive_speed (&hwif->drives[0], XFER_UDMA_2);
//	ide_config_drive_speed (&hwif->drives[0], XFER_PIO_4);

	hwif->autodma = 1;
	// setup busmaster dma
	ide_setup_dma(hwif, JASPER_IDE_DMA_BASE, 16);
/*	printk("enabling dma on drive 0\n");
	hwif->dmaproc(ide_dma_on, &hwif->drives[0]);

	printk("enabling dma on drive 1\n");
	hwif->dmaproc(ide_dma_on, &hwif->drives[1]);*/
}


