/*
 * linux/include/asm-armnommu/arch-jasper/ide.h
 *
 */
 
#include <linux/config.h>
#include <asm/irq.h>
#include <asm/hardware.h>

#define HAVE_ARCH_IN_BYTE
#define HAVE_ARCH_OUT_BYTE

#define OUT_BYTE(b,p)                \
do {                                 \
   int _tmp_;                        \
   outb((b),(p));                    \
   for(_tmp_=0; _tmp_<1000; _tmp_++);  \
} while(0) 

static inline byte jasper_ide_in_byte(int p)
{
	byte b; int _tmp;

	b = (byte)inb(p);
	for(_tmp=0; _tmp<1000; _tmp++);
	return b;
}

#define IN_BYTE(p) jasper_ide_in_byte(p)


/*
 * Set up a hw structure for a specified data port, control port and IRQ.
 * This should follow whatever the default interface uses.
 */
static __inline__ void
ide_init_hwif_ports(hw_regs_t *hw, int data_port, int ctrl_port, int *irq)
{
	ide_ioreg_t reg;
	int i;
	int regincr = 1;
	
	memset(hw, 0, sizeof(*hw));

	reg = (ide_ioreg_t)data_port;

	for (i = IDE_DATA_OFFSET; i <= IDE_STATUS_OFFSET; i++) {
		hw->io_ports[i] = reg;
		reg += regincr;
	}
	
	hw->io_ports[IDE_CONTROL_OFFSET] = (ide_ioreg_t) ctrl_port;
	
	if (irq)
		*irq = 0;
}


/*
 * This registers the standard ports for this architecture with the IDE
 * driver.
 */
static __inline__ void
ide_init_default_hwifs(void)
{
    hw_regs_t hw;

    ide_init_hwif_ports(&hw, JASPER_IDE_BASE + IDE_PRI_DATA, JASPER_IDE_BASE + IDE_PRI_DEVICE_CONTROL, NULL);
    hw.irq = IDE_IRQ;
    ide_register_hw(&hw, NULL);
}


