/*
 *  linux/include/asm-armnommu/arch-jasper/irqs.h
 *
 *  Copyright (C) 1999 ARM Limited
 *  Copyright (C) 2000 Deep Blue Solutions Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <asm/arch/hardware.h>

/* 
 *  IRQ interrupts definitions are the same the INT definitions
 *  held within hardware.h
 */

#define         NR_IRQS                         23

#define         Q2H_LOC_IRQ                     22
#define         Q2H_RISC_IRQ                    21
#define         SPI_IRQ                         20
#define         SPI_I2S_DMA_IRQ                 19
#define         I2S_IRQ                         18
#define         RTC_IRQ                         17
#define         Q2P_DMA_IRQ                     16
#define         P2Q_DMA_IRQ                     15
#define         OSD_DMA_IRQ                     14
#define         FIP_IRQ                         13
#define         IDE_DMA_IRQ                     12
#define         IDE_IRQ                         11
#define         DVD_DMA_IRQ                     10
#define         DVD_IRQ                         9
#define         I2CS_IRQ                        8
#define         I2CM_IRQ                        7
#define         PIO1_IRQ                        6
#define         PIO_IRQ                         4
#define         UART1_IRQ                       3
#define         UART0_IRQ                       2
#define         WDTIMER_IRQ                     1
#define         TIMER0_IRQ                      0

// UART Definition

#define JASPER_UART0_IRQ UART0_IRQ
#define JASPER_UART1_IRQ UART1_IRQ
