// THIS FILE "const.h" was writen for the Quasar 3 + 3.5 
// chip generation. 
// As Q3.5 became obsolete and Q4 was implemented the new 
// file used is Q4.h
// The goal is to transfer all necesary definitions to Q4.h and
// only use that file in the future.

#define RBUS_reset_run					0x1000

//---------------------------------------------------
//------ DRAM Controller control registers ---------
//---------------------------------------------------
#define DRAM_config						0xC00
#define DRAM_fifosize0					0xC01 
#define DRAM_fifosize1					0xC02 
#define DRAM_pllcontrol					0xC04 
#define DRAM_ac3_base					0xC0A
#define DRAM_fifosize2					0xC0B
#define DRAM_portmux					0xC0C  

//---BASE ADDRESSES OF DRAM CHANNELS--------------
#define HOST_TO_DRAM_base				0xC10
#define RISC_TO_DRAM_base				0xC20
#define DRAM_TO_HOST_base				0xC50
#define DRAM_TO_RISC_base				0xC60
#define DRAM_TO_HD_base					0xC70
#define MC_TO_DRAM_base					0xC80
#define Display_Luma_base				0xC90
#define Display_Chroma_base				0xCA0
#define DRAM_TO_SPUTop_base				0xCB0
#define DRAM_TO_SPUBot_base				0xCC0
#define DRAM_TO_SPUCom_base				0xCD0
#define DRAM_TO_SPDIF_base  			0xCE0

#define W0_CNTR       					0xC10  
#define W0_ADDD_L0						0xC11
#define W0_ADDD_HI						0xC12
#define W0_XCNT							0xC13
#define W0_XCNT_RELOAD					0xC14
#define W0_XCNT_SKIP					0xC15
#define W0_YCNT							0xC16
#define W0_YCNT_RELOAD					0xC17
#define W0_ADD_RELOAD_LO				0xC18
#define W0_ADD_RELOAD_HI				0xC19
#define W0_ZCNT							0xC1A

//---DRAM control register offsets Type 0-------------
#define control0	0				//(R/W)
#define addlo0		1               //(R/W)
#define addhi0		2               //(R/W)
#define xcnt0		3               //(R/W)
#define xcnt_rld0	4               //(R/W)
#define xskip0		5               //(R/W)
#define ycnt0		6               //(R/W)
#define ycnt_rld0	7               //(R/W)
#define add_rld_lo0	8               //(R/W)
#define add_rld_hi0	9               //(R/W)
#define zcnt0		0xA             //(R/W)

//---DRAM control register offsets Type 1-------------
#define control1	0				//(R/W)
#define addlo1		1 				//(R/W)
#define addhi1		2               //(R/W)
#define xcnt1		3               //(R/W)
#define xcnt_rld1	4               //(R/W)
#define add_rld_lo1	8               //(R/W)
#define add_rld_hi1	9               //(R/W)
#define zcnt1		0xA             //(R/W)

//---DRAM control register offsets Type 2-------------
#define control2	0				//(R/W)
#define addlo2		1 				//(R)
#define addhi2		2               //(R)
#define xcnt2		3               //(R)
#define xcnt_rld2	4               //(R)
#define xskip2		5               //(R)
#define ycnt2		6               //(R)
#define zcnt2		0xA             //(R)


//----- RISC(MISC) to DRAM transfer control registers
// (Channel W1)
#define write_DRAM_control				0xC20   // r/w
#define write_DRAM_addlo				0xC21   // R/W
#define write_DRAM_addhi				0xC22   // R/W
#define write_DRAM_xcnt					0xC23   // R/W
#define write_DRAM_xcnt_rld				0xC24   // R/W
#define write_DRAM_xskip				0xC25   // R/W
#define write_DRAM_ycnt					0xC26   // R/W
#define write_DRAM_ycnt_rld				0xC27   // R/W
#define write_DRAM_add_rld_lo			0xC28   // R/W
#define write_DRAM_add_rld_hi			0xC29   // R/W
#define write_DRAM_zcnt					0xC2A   // R/W

#define W3_CNTR       					0xC40  
#define W3_ADDD_L0						0xC41
#define W3_ADDD_HI						0xC42
#define W3_XCNT							0xC43
#define W3_XCNT_RELOAD					0xC44
#define W3_YCNT							0xC46
#define W3_YCNT_RELOAD					0xC47
#define W3_ZCNT							0xC4A

#define R0_CNTR       					0xC50  
#define R0_ADDD_L0						0xC51
#define R0_ADDD_HI						0xC52
#define R0_XCNT							0xC53
#define R0_XCNT_RELOAD					0xC54
#define R0_YCNT							0xC56
#define R0_YCNT_RELOAD					0xC57
#define R0_ZCNT							0xC5A

// (Channel R1)
#define read_DRAM_control				0xC60   // r/w
#define read_DRAM_addlo					0xC61   // R/W
#define read_DRAM_addhi					0xC62   // R/W
#define read_DRAM_xcnt					0xC63   // R/W
#define read_DRAM_xcnt_rld				0xC64   // R/W
#define read_DRAM_xskip					0xC65   // R/W
#define read_DRAM_ycnt					0xC66   // R/W
#define read_DRAM_ycnt_rld				0xC67   // R/W
#define read_DRAM_add_rld_lo			0xC68   // R/W
#define read_DRAM_add_rld_hi			0xC69   // R/W
#define read_DRAM_zcnt					0xC6A   // R/W

//------ DRAM to Huffman Decoder transfer control registers
// (Channel R2)	- HD FIFO control
#define HDF_control						0xC70   // r/w
#define HDF_addlo						0xC71   // R/W
#define HDF_addhi						0xC72   // R/W
#define HcDF_length						0xC73   // R/W
#define HDF_length_rld					0xC74   // R/W
#define HDF_add_rld_lo					0xC78   // R/W
#define HDF_add_rld_hi					0xC79   // R/W
#define HDF_transfer_cnt				0xC7A   // R/W

//-- SPDIF serial interface -------------------------
// (Channel R9)
#define SPDIF_SERIAL_R9_control			0xCE0   // r/w
#define SPDIF_SERIAL_R9_addlo			0xCE1   // R/W
#define SPDIF_SERIAL_R9_addhi			0xCE2   // R/W
#define SPDIF_SERIAL_R9_xcnt			0xCE3   // R/W
#define SPDIF_SERIAL_R9_xcnt_rld		0xCE4   // R/W
#define SPDIF_SERIAL_R9_xskip			0xCE5   // R/W
#define SPDIF_SERIAL_R9_ycnt			0xCE6   // R/W
#define SPDIF_SERIAL_R9_ycnt_rld		0xCE7   // R/W
#define SPDIF_SERIAL_R9_add_rld_lo		0xCE8   // R/W
#define SPDIF_SERIAL_R9_add_rld_hi		0xCE9   // R/W
#define SPDIF_SERIAL_R9_zcnt			0xCEA   // R/W

//-----  HOST WRITE 2 -------------------------------
// (Channel W4)
#define HOST_DRAM_2_control				0xCF0   // r/w
#define HOST_DRAM_2_addlo				0xCF1   // R/W
#define HOST_DRAM_2_addhi				0xCF2   // R/W
#define HOST_DRAM_2_xcnt				0xCF3   // R/W
#define HOST_DRAM_2_xcnt_rld			0xCF4   // R/W
#define HOST_DRAM_2_xskip				0xCF5   // R/W
#define HOST_DRAM_2_ycnt				0xCF6   // R/W
#define HOST_DRAM_2_ycnt_rld			0xCF7   // R/W
#define HOST_DRAM_2_add_rld_lo			0xCF8   // R/W
#define HOST_DRAM_2_add_rld_hi			0xCF9   // R/W
#define HOST_DRAM_2_zcnt				0xCFA   // R/W

#define W4_CNTR       					0xCF0  
#define W4_ADDD_L0						0xCF1
#define W4_ADDD_HI						0xCF2
#define W4_XCNT							0xCF3
#define W4_XCNT_RELOAD					0xCF4
#define W4_YCNT							0xCF6
#define W4_YCNT_RELOAD					0xCF7
#define W4_ZCNT							0xCFA


//-- J1 -> DRAM   -------------------------
// (Channel W5)
#define AC3_W5_control					0xD00   // r/w
#define AC3_W5_addlo					0xD01   // R/W
#define AC3_W5_addhi					0xD02   // R/W
#define AC3_W5_R9_xcnt					0xD03   // R/W
#define AC3_W5_xcnt_rld					0xD04   // R/W
#define AC3_W5_xskip					0xD05   // R/W
#define AC3_W5_ycnt						0xD06   // R/W
#define AC3_W5_ycnt_rld					0xD07   // R/W
#define AC3_W5_add_rld_lo				0xD08   // R/W
#define AC3_W5_add_rld_hi				0xD09   // R/W
#define AC3_W5_zcnt						0xD0A   // R/W

	
//-- DRAM -> J1  -------------------------
// (Channel R10)
#define AC3_R10_control					0xD10   // r/w
#define AC3_R10_addlo					0xD11   // R/W
#define AC3_R10_addhi					0xD12   // R/W
#define AC3_R10_xcnt					0xD13   // R/W
#define AC3_R10_xcnt_rld				0xD14   // R/W
#define AC3_R10_xskip					0xD15   // R/W
#define AC3_R10_ycnt					0xD16   // R/W
#define AC3_R10_ycnt_rld				0xD17   // R/W
#define AC3_R10_add_rld_lo				0xD18   // R/W
#define AC3_R10_add_rld_hi				0xD19   // R/W
#define AC3_R10_zcnt					0xD1A   // R/W

#define R11_CNTR       					0xD20  
#define R11_ADDD_L0						0xD21
#define R11_ADDD_HI						0xD22
#define R11_XCNT						0xD23
#define R11_XCNT_RELOAD					0xD24
#define R11_YCNT						0xD26
#define R11_ZCNT						0xD2A


//---------------------------------------------------
//-----  Local BUS LBC  -----------------------------
//---------------------------------------------------
#define LBC_config						0xE40
#define LBC_config1						0xE41
#define LBC_write_fifo0_access          0xE42
#define LBC_write_fifo0_cnt             0xE43
#define LBC_read_fifo0_access           0xE44
#define LBC_read_fifo0_cnt              0xE45
#define LBC_read_fifo1_access           0xE46
#define LBC_read_fifo1_cnt              0xE47
#define LBC_write_reg_addr              0xE48
#define LBC_write_reg_data              0xE49
#define LBC_read_reg_addr               0xE4A
#define LBC_read_reg_data               0xE4B
#define LBC_burst_xfer_ctrl             0xE4C
#define LBC_status_reg                  0xE4D
#define LBC_interrupt_reg               0xE4E
#define LBC_PGIO_reg                    0xE4F

//---------------------------------------------------
//-----  OSD DMA channel			DBUS ADR
//---------------------------------------------------
#define OSD_source_rd_lo				0xE60
#define OSD_source_rd_hi				0xE61																
#define OSD_source_rd_counter			0xE62
#define OSD_source_mux_en				0xE63
#define OSD_rd_int_mask					0xE64
#define OSD_rd_int						0xE65
#define OSD_rd_int_status				0xE66

//---------------------------------------------------
//------ Huffman decoder registers -----------------
//---------------------------------------------------
#define HD_cmd							0xF00	// Write only
#define HD_result						0xF01   // Read only
#define HD_cntlo						0xF08   // R/W
#define HD_cnthi						0xF09   // R/W

//------ MC registers -----------------------------------
#define MC_Base							0xF10
#define YBASE0L0						0		// R/W
#define YBASE0HI						1		// R/W
#define CBASE0L0						2		// R/W
#define CBASE0HI						3		// R/W
#define YBASE1L0						4		// R/W
#define YBASE1HI						5		// R/W
#define CBASE1L0						6		// R/W
#define CBASE1HI						7		// R/W
#define YBASE2L0						8		// R/W
#define YBASE2HI						9		// R/W
#define CBASE2L0						0xA		// R/W
#define CBASE2HI						0xB		// R/W
#define PICSIZE							0xC		// R/W
#define STRIDE							0xD		// R/W
#define MC_cmd							0xE		// W
#define MC_status						0xE		// R

//--------Display Controller addresses-----------------
                        
#define VID_REG_BASE					0xf40
#define VID_Y_BCS						0
#define VID_C_BCS						1
#define VID_HSYNC_LO					2
#define VID_HSYNC_HI					3
#define VID_VSYNC_LO					4
#define VID_VSYNC_HI					5
#define VID_VSYNC_DLY					6
#define VID_SYNC_CTRL					7
#define VID_Y_MPEGLINE					8
#define VID_C_MPEGLINE					9
#define VID_SCAN_LINE					0xA
#define VID_SCAN_MAX					0xB
//#define PIO_DATA          				0xD
//#define PIO_DIR           				0xE

#define VID_REG_BASE_2					0xf50
#define VID_WIDTH						0x3
#define VID_HEIGHT						0x4
#define VID_DISCARD						0x5
#define VID_HDS_SCALE					0x6
#define VID_VUS_SCALE					0x7   
#define VID_HUS_SCALE     				0x8
#define VID_US_PHASE      				0x9
#define VID_WIN_TOP       				0xA
#define VID_WIN_BOT       				0xB
#define VID_WIN_LEFT      				0xC
#define VID_WIN_RIGHT     				0xD
#define VID_CTRL          				0xE
#define VID_IRQ           				0xF

//------- Sub picture module registers------------------------------
#define SP_REG_BASE						0xf60
#define SP_COLOR						0
#define SP_CONTRAST						1
#define SP_HOFFSET						2
#define SP_VOFFSET						3
#define SP_WIDTH						4
#define SP_HEIGHT						5
#define SP_HCROP_WIDTH					6
#define SP_VDS_SCALE					7
#define SP_HDS_SCALE					8
#define SP_VUS_SCALE					9
#define SP_HUS_SCALE					10
#define SP_WIN_TOP						11
#define SP_WIN_BOT						12
#define SP_WIN_LEFT						13
#define SP_WIN_RIGHT					14
#define SP_CTRL							15

#define SP_REG_BASE_2					0xf70
#define BTN_COLOR          				0
#define BTN_CONTR          				1
#define BTN_WIN_TOP        				2
#define BTN_WIN_BOT        				3
#define BTN_WIN_LEFT       				4
#define BTN_WIN_RIGHT      				5
                             
#define SP_CLUT_BASE					0xf80
#define SP_CLUT_Y0						0x0
#define SP_CLUT_C0						0x1
#define SP_CLUT_Y1						0x2
#define SP_CLUT_C1						0x3
#define SP_CLUT_Y2						0x4
#define SP_CLUT_C2						0x5
#define SP_CLUT_Y3						0x6
#define SP_CLUT_C3						0x7
#define SP_CLUT_Y4						0x8
#define SP_CLUT_C4						0x9
#define SP_CLUT_Y5						0xA
#define SP_CLUT_C5						0xB
#define SP_CLUT_Y6						0xC
#define SP_CLUT_C6						0xD
#define SP_CLUT_Y7						0xE
#define SP_CLUT_C7						0xF   

#define SP_CLUT_BASE_2					0xf90
#define SP_CLUT_Y8         				0x0
#define SP_CLUT_C8						0x1
#define SP_CLUT_Y9						0x2
#define SP_CLUT_C9						0x3
#define SP_CLUT_Y10						0x4
#define SP_CLUT_C10						0x5
#define SP_CLUT_Y11						0x6
#define SP_CLUT_C11						0x7
#define SP_CLUT_Y12						0x8
#define SP_CLUT_C12						0x9
#define SP_CLUT_Y13						0xA
#define SP_CLUT_C13						0xB
#define SP_CLUT_Y14						0xC
#define SP_CLUT_C14						0xD
#define SP_CLUT_Y15						0xE
#define SP_CLUT_C15						0xF

#define SP_CLUT_YC						0xf80
#define SP_CLUT_SIZE					32

//---------------------------------------------------
//-----  AUDIO/PCM    -------------------------------
//---------------------------------------------------
#define AUDIO_pcm_mix0					0xFB0   // R/W
#define AUDIO_pcm_mix1					0xFB1   // R/W
#define AUDIO_pcm_mix2					0xFB2   // R/W
#define AUDIO_pcm_mix3					0xFB3   // R/W
#define AUDIO_pcm_mix4					0xFB4   // R/W
#define AUDIO_pcm_mix5					0xFB5   // R/W
#define AUDIO_pcm_mix6					0xFB6   // R/W
#define AUDIO_pcm_mix7					0xFB7   // R/W
#define AUDIO_pcm_invert				0xFB8   // R/W
#define AUDIO_pcm_config0				0xFB9   // R/W 
#define AUDIO_pcm_config1				0xFBA   // R/W 

//---------------------------------------------------
//-----  AUDIO/AC3    -------------------------------
//---------------------------------------------------
#define AUDIO_ac3_status_lo				0xFC0   // R
#define AUDIO_ac3_status_hi				0xFC1   // R
#define AUDIO_ac3_cop					0xFC2   // R/W/A
#define AUDIO_ac3_mode					0xFC3   // R/W
#define AUDIO_ac3_romaddsel				0xFC4   // R/W 
#define AUDIO_ac3_romdatalo				0xFC5   // R/W
#define AUDIO_ac3_romdatahi				0xFC6   // R/W

//---------------------------------------------------
//-----  AUDIO/SERIAL -------------------------------
//---------------------------------------------------
#define AUDIO_bytecnt_lo				0xFD0   // R/W 
#define AUDIO_bytecnt_hi				0xFD1   // R/W 
#define AUDIO_bytecnt_trig_lo			0xFD2   // R/W 
#define AUDIO_bytecnt_trig_hi			0xFD3   // R/W 
#define AUDIO_sync_state       			0xFD4   // R/W/A 
#define AUDIO_serial_ctrl0      		0xFD5   // R/W
#define AUDIO_serial_ctrl1      		0xFD6   // R/W
#define AUDIO_serial_gain       		0xFD7   // R/W
#define AUDIO_spdif_ch_stat0    		0xFD8   // R/W
#define AUDIO_spdif_ch_stat1    		0xFD9   // R/W
#define AUDIO_in_counter        		0xFDB   // R/W

//---------------------------------------------------
//------ PCI Master					DBUS ADR
//-----  H2Q DMA Registers			DBUS ADR
//---------------------------------------------------
#define PCI_Add_Lo						0xFE0
#define PCI_Add_Hi						0xFE1
#define PCI_DataCounter					0xFE2
#define PCI_SecondaryMasterEnable		0xFE3
#define PCI_DataOrder					0xFE4
//---------------------------------------------------
#define HOST_Add_Lo						0xFE0
#define HOST_Add_Hi						0xFE1
#define HOST_DataCounter				0xFE2
#define HOST_SecondaryMasterEnable		0xFE3
#define HOST_H2Q_int_mask				0xFE4
#define HOST_H2Q_int					0xFE5
#define HOST_H2Q_int_status				0xFE6
//---------------------------------------------------

//---------------------------------------------------
//-----  QMP-DBUS Registers			DBUS ADR
//-----  Q2H DMA Registers			DBUS ADR
//---------------------------------------------------
#define QMP_waddr_lo					0xFE8	// new in Quasar3.5
#define QMP_waddr_hi					0xFE9	// new in Quasar3.5
#define QMP_xfer_cnt					0xFEA	// new in Quasar3.5
#define QMP_wmaster_ena					0xFEB	// new in Quasar3.5
//---------------------------------------------------
#define Q2H_wr_addr_lo					0xFE8
#define Q2H_wr_addr_hi					0xFE9
#define Q2H_wr_counter					0xFEA
#define Q2H_wr_master_en				0xFEB
#define Q2H_rd_int_mask					0xFEC
#define Q2H_rd_int						0xFED
#define Q2H_rd_int_status				0xFEE

//---------------------------------------------------
//------ RISCMISC block control registers ----------
//---------------------------------------------------
#define RISC_misc_base					0xff0
#define RISC_mode_w						0		// 0xff0
#define RISC_length_w					1		// 0xff1
#define RISC_address_w					2		// 0xff2
#define RISC_loopback					3		// 0xff3
#define RISC_mode_r						4		// 0xff4
#define RISC_length_r					5		// 0xff5
#define RISC_address_r					6		// 0xff6
#define RISC_resets_0					8		// 0xff8
#define RISC_resets_1					9		// 0xff9
#define RISC_irq						0xa		// 0xffa
#define RISC_tim_div					0xb		// 0xffb
#define RISC_tim_cnt					0xc		// 0xffc
//---------------------------------------------------
#define write_RAM_mode					0xFF0   // R/W	 (mode_w)
#define write_RAM_length				0xFF1   // R/W	 (length_w)
#define write_RAM_address				0xFF2   // R/W	 (address_w)
#define RISC_DRAM_loopback				0xFF3   // R/W
#define read_RAM_mode					0xFF4   // R/W	 (mode_r)
#define read_RAM_length					0xFF5   // R/W	 (length_r)
#define read_RAM_address				0xFF6   // R/W	 (address_r)
#define RISCMISC_reserved				0xFF7	// reserved
#define RISC_reset0						0xFF8
#define RISC_reset1						0xFF9
#define Q2H_RISC_INT_REG				0xFFA	//irq_control	
#define	TIM_div							0xFFB	// timer division R/W
#define TIM_count						0xFFC	// R
#define TIM_irq_clr						0xFFC	// W

//-*************************************************
//------ Parser definition         -----------------
//-*************************************************
#define Parser0_ctrl					0xFF7
#define Parser0_ptr						0xFFD
#define Parser1_ptr						0xFFE 
#define Parser1_ctrl					0xFFF



//---------------------------------------------------
//--- CONSTANT / COMMAND DEFINITIONS			  ---
//---------------------------------------------------

//--- dram ctrl constant definitions------------
#define	TIMING				0x7
#define REFRESH_PEROID		127
#define	DRSIZE							0x0	// SDRAM 2MB 16 bit data
//#define	DRSIZE						0x1	// SDRAM 2MB 32 bit data
#define DRAM_REFRESH					64
#define DRAM_TIMING						0
#define DRAM_FIFO0						0x5555
#define DRAM_FIFO1						0x0555
#define TrMaxSize			0x1000	// the maximum size of the transfer	
									// from the video bitstream buffer (4KBytes)
#define BSizeMax			0x40	// the buffer maximum size x 0x10000 (4MBytes)
#define typ_tmax			8		// the typical value of the time-window 
									// allocated to each DRAM channel

// Huffman FIFO watch values
#define FIFOWATCH_IDLE      0
#define FIFOWATCH_ARMED     1
#define FIFOWATCH_2ND       2
#define FIFOWATCH_UNDERFLOW 3

// Huffman decoder reset masks
#define HD_UNRESET_MASK 0x2000
#define HD_RESET_MASK	0x2020

// Motion compensation reset masks
#define MC_UNRESET_MASK 0x4000
#define MC_RESET_MASK	0x4040

// MPEG engine (MC+IQZ+IDCT+HD) reset masks
#define MPEG_UNRESET_MASK 0xE000
#define MPEG_RESET_MASK	  0xE0E0

// MC+IQZ+IDCT reset masks
#define MCIDCT_UNRESET_MASK 0xC000
#define MCIDCT_RESET_MASK	0xC0C0

// RISCMISC reset masks
#define RISCMISC_UNRESET_MASK 0x1800
#define RISCMISC_RESET_MASK	  0x1818

// set PCI interrupt 
#define set_PCIint		  3

//------ Inverse quantizer matrices start address -------
#define QZ_iqm			  0xE00
#define QZ_niqm			  0xE20

//------ PCI IRQ register -------------------------------
#define SP_init			  0x201		  // stack pointer initial value
#define	ThRes			  0xA		  // the resolution of the buffer threshold value 

//------ MC commands -----------------------------------
#define FWD_16x16  		0x1c0	// load command
#define FWD_TOP_FLD  	0x1c1	// load command
#define FWD_BOTT_FLD  	0x1c2	// load command
#define FWD_16x8U  		0x1c3	// load command
#define FWD_16x8B  		0x1c4	// load command
#define BWD_16x16  		0x9c0	// load command 
#define BWD_TOP_FLD  	0x9c1	// load command
#define BWD_BOTT_FLD  	0x9c2	// load command
#define BWD_16x8U  		0x9c3	// load command
#define BWD_16x8B  		0x9c4	// load command
#define STO_FRM  		0x5100	// store command
#define STO_FLD  		0x5500	// store command

#define MV_BuffStart_Lo	0x44 
#define MV_BuffStart_Hi	0x45 
#define MV_BuffSize_Lo	0x46 
#define MV_BuffSize_Hi	0x47 
#define MV_RdPtr_Lo	0x48 
#define MV_RdPtr_Hi	0x49 
#define MV_WrPtr_Lo	0x4b 
#define MV_WrPtr_Hi	0x4c 
	
//------- Error Codes -----------------------------------

//-----------------
// sequence header
//-----------------
#define	null_pic_size				1   
#define	no_aspect_ratio				2
#define	frame_rate_err    			3
#define	frame_rate_ext_err			4
#define markbit_err					5
#define seq_no_ext					6
#define seq_no_seqext				7
#define unknown_PL					8
#define unsupp_PL					9
#define unsupp_chroma				10
#define s_iqm_err					11
#define s_niqm_err					12

//----------------
// picture header
//----------------
#define no_vec_info					13
#define no_pic_type					14
#define pic_no_ext  				15
#define pic_no_picext  				16
#define null_r_size  				17
#define unknown_picstr				18
#define p_iqm_err					19
#define p_niqm_err					20
#define ch_iqm_err					21
#define ch_niqm_err					22
#define wrong_slice_sc				23

//--------------
// slice header
//--------------
#define wrong_skip					24
#define null_motion_type			25



//------- Start Codes ------------------------------
#define SEQUENCE_HEADER_CODE		0xB3
#define GROUP_START_CODE			0xB8
#define PICTURE_START_CODE			0x00

#define EXTENSION_START_CODE		0xB5  
#define USER_DATA_START_CODE		0xB2
#define	SEQUENCE_END_CODE			0xB7
#define END_OF_STREAM				0x1F0
//------- Extension ID Codes ------------------------------
#define PIC_COD_ID 					8
#define SEQ_EXT_ID					1

//------- MPEG2 constants ------------------------------
#define MP_ML						0x48  
#define CHROMA420       			1
                                
// SP Display Control Command Codes

#define FSTA_DSP	0
#define STA_DSP		1
#define STP_DSP	2
#define SET_COLOR	3
#define SET_CONTR	4
#define SET_DAREA	5
#define SET_DSPXA	6
#define CHG_COLCON	7
#define CMD_END		0xff



#define PM_DESTINATION_LOW      0x00
#define PM_DESTINATION_HIGH     0x01


//---------------------------------------------------
//-----  Stream Machine constant  -------------------
//---------------------------------------------------
#define SM_HOST_COMMAND                 0x0002 
#define SM_TX_FIFO                      0x0006
#define SM_RC_FIFO                      0x0008
#define SM_INT_EN_CONTROL               0x000A
#define SM_INT_INFO                     0x000C
#define SM_DMA_INFO1_REG                0x000E
#define SM_DMA_INFO2_REG                0x0010
#define SM_BT_CNT_REG                   0x0016
#define SM_I2C_TRANSMIT                 0x0018
#define SM_I2C_RECEIVE                  0x001A
#define SM_UCODE_DOWN                   0x001C
#define SM_VQ_SIZE_Lo                   0x0020
#define SM_VQ_SIZE_Hi                   0x0022
#define SM_DRAM_TRAN_FIFO               0x8000
#define SM_MPEG_RC_FIFO                 0xC000

      
//---------------------------------------------------
//-----  ERROR CODE  in DM[SM_ERROR]   --------------
//---------------------------------------------------
#define SM_WR_ADDR_REG_ERROR           0x00001
#define SM_WR_DATA_REG_ERROR           0x00002
#define SM_RD_ADDR_REG_ERROR           0x00003
#define SM_RD_DATA_REG_ERROR           0x00004

//---------------------------------------------------
//-----  INT PENDING for READ ONLY      --------------
//---------------------------------------------------
#define INT0_PENDING                   0x0001 
#define INT1_PENDING                   0x0002 
#define INT2_PENDING                   0x0004 
#define INT3_PENDING                   0x0008 

//---------------------------------------------------
//-----  LBC_status BITs               --------------
//---------------------------------------------------
#define LBC_status_RR                  0x0001 
#define LBC_status_RW                  0x0002
#define LBC_status_LWCH0               0x0004
#define LBC_status_LRCH0               0x0008
#define LBC_status_LRCH1               0x0010

//---------------------------------------------------
//-----  Kfir registers                --------------
//---------------------------------------------------
#define Kfir_DMA_BSM_BURST      96
#define Kfir_DMA_BSM_BURST_END  97
#define Kfir_DMA_VIB_BURST      98
#define Kfir_DMA_VIB_BURST_END  99
#define Kfir_DEV_INST           200
#define Kfir_DATA_MSB           202 // FIFO WRITE MSB
#define Kfir_VIB_FIFO           203 // FIFO READ LSB
#define Kfir_AUDIO_MEM          204 // FIFO READ MSB
#define Kfir_I960_MASTER        211
#define Kfir_FILE_MODE          212
#define Kfir_RESET_REGS         213 //D5
#define Kfir_RESET_FIFO         214 //D6 
#define Kfir_VIDEO_INTER_BURST  219
#define Kfir_INTER_CNT          221 //DD
#define Kfir_AUDIO_INT_ACK      228
#define Kfir_AUDIO_FRAME_SIZE   229
#define Kfir_VIDEO_INTER        234
#define Kfir_DMA_MUX_INTER      236
#define Kfir_DMA_VIB_INTER      237
#define Kfir_EREADY             254 // FE
#define Kfir_RECORD             255 // FF


//**************************************************
//******* IO related defines  **********************
//**************************************************


// Huffman decoder commands
#define GET_SC			0x11
#define BYTEALIGN		0x12
#define GET_MB			0x31
#define GET_MBAI        0x13
#define GET_MBTYPE      0x13
#define GET_CBP_CBPY    0x17
#define GET_MV          0x18
#define GET_DMV_MODB    0x19
#define RESET_ERR       0x3F

// Other Stuff
#define MAX_WrRdPTR_ParserSize80H 0x7F
