/***************************************************
JASPER/QUASAR4
updated 2001-12-19 according to Specification
***************************************************/
#define Q4_RISC_reset_run				0x2000		//[1..0]

/***************************************************
JASPER/QUASAR4 LOCAL BUS CTRL - LBC
updated 2001-12-20 according to Q4 LBC Specification
***************************************************/
#define Q4_LBC_config0					0x1E40
#define Q4_LBC_config1					0x1E41
#define Q4_LBC_write_fifo0_access		0x1E42
#define Q4_LBC_write_fifo0_cnt			0x1E43
#define Q4_LBC_read_fifo0_access		0x1E44
#define Q4_LBC_read_fifo0_cnt			0x1E45
#define Q4_LBC_read_fifo1_access		0x1E46
#define Q4_LBC_read_fifo1_cnt			0x1E47
#define Q4_LBC_write_addr				0x1E48
#define Q4_LBC_write_data				0x1E49
#define Q4_LBC_read_reg_addr			0x1E4a
#define Q4_LBC_read_reg_data			0x1E4b
#define Q4_LBC_burst_xfer_ctrl			0x1E4c
#define Q4_LBC_status					0x1E4d
#define Q4_LBC_interrupt				0x1E4e
#define Q4_LBC_pgio						0x1E4f

/***************************************************
JASPER/QUASAR4 MPEG4_Huffmann_Decoder 	DBUS REG
updated 2001-12-19 according to MPEG4_Huffmann_Decoder 
specification
***************************************************/
#define Q4_HD4_command					0x1F00
#define Q4_HD4_MB_type					0x1F01
#define Q4_HD4_result_lo				0x1F02
#define Q4_HD4_result_hi				0x1F03
#define Q4_HD4_cbp						0x1F04
#define Q4_HD4_r_size					0x1F05
#define Q4_HD4_config					0x1F06
#define Q4_HD4_qscale					0x1F07
#define Q4_HD4_cnt_lo					0x1F08
#define Q4_HD4_cnt_hi					0x1F09
#define Q4_HD4_dc0						0x1F0A
#define Q4_HD4_dc1						0x1F0B
#define Q4_HD4_dc2						0x1F0C
#define Q4_HD4_dc3						0x1F0D
#define Q4_HD4_dc4						0x1F0E
#define Q4_HD4_dc5						0x1F0F

/***************************************************
JASPER/QUASAR4 AUDIO 
updated 2001-12-20 according to Jasper Audio Specification
***************************************************/
// PCM
#define Q4_AUDIO_pcm_mix0				0x1FB0
#define Q4_AUDIO_pcm_mix1				0x1FB1
#define Q4_AUDIO_pcm_mix2				0x1FB2
#define Q4_AUDIO_pcm_mix3				0x1FB3
#define Q4_AUDIO_pcm_mix4				0x1FB4
#define Q4_AUDIO_pcm_mix5				0x1FB5
#define Q4_AUDIO_pcm_mix6				0x1FB6
#define Q4_AUDIO_pcm_mix7				0x1FB7
#define Q4_AUDIO_pcm_mix_invert			0x1FB8
#define	Q4_AUDIO_pcm_mix_config0		0x1FB9
#define Q4_AUDIO_pcm_mix_config1		0x1FBA
// AC3
#define Q4_AUDIO_ac3_status_lo			0x1FC0
#define Q4_AUDIO_ac3_status_hi			0x1FC1
#define Q4_AUDIO_ac3_cop				0x1FC2
#define Q4_AUDIO_ac3_mode				0x1FC3
#define Q4_AUDIO_ac3_romaddrsel			0x1FC4
#define Q4_AUDIO_ac3_romdatalo			0x1FC5
#define Q4_AUDIO_ac3_romdatahi			0x1FC6
// SYNCHRONISATION
#define Q4_AUDIO_bytecnt_lo				0x1FD0 
#define Q4_AUDIO_bytecnt_hi				0x1FD1 
#define Q4_AUDIO_bytecnt_trig_lo		0x1FD2 
#define Q4_AUDIO_bytecnt_trig_hi		0x1FD3
#define Q4_AUDIO_sync_state				0x1FD4
// Serial Interface
#define Q4_AUDIO_serial_ctrl0			0x1FD5 
#define Q4_AUDIO_serial_ctrl1			0x1FD6
#define Q4_AUDIO_serial_gain			0x1FD7
#define Q4_AUDIO_spdif_ch_stat0			0x1FD8
#define Q4_AUDIO_spdif_ch_stat1			0x1FD9
#define Q4_AUDIO_in_counter				0x1FDB
// JDA1
#define Q4_AUDIO_jda1_config			0x1FDC
#define Q4_AUDIO_jda1_setup_lo			0x1FDD
#define Q4_AUDIO_jda1_setup_hi			0x1FDE

/***************************************************
JASPER/QUASAR4 LBC						DBUS REG
updated 2002-07-29 according to Jasper_LBC specification
***************************************************/
#define Q4_H2Q_hostmem_addr_lo			0x1FE0
#define Q4_H2Q_hostmem_addr_hi			0x1FE1
#define Q4_H2Q_byte_counter				0x1FE2
#define Q4_H2Q_master_enable			0x1FE3
#define Q4_H2Q_int_mask					0x1FE4
#define Q4_H2Q_int						0x1FE5
#define Q4_H2Q_int_status				0x1FE6

#define Q4_Q2H_hostmem_addr_lo			0x1FE8
#define Q4_Q2H_hostmem_addr_hi			0x1FE9
#define Q4_Q2H_byte_counter				0x1FEA
#define Q4_Q2H_master_enable			0x1FEB
#define Q4_Q2H_int_mask					0x1FEC
#define Q4_Q2H_int						0x1FED
#define Q4_Q2H_int_status				0x1FEE


/***************************************************
JASPER/QUASAR4 MPEG_MISC				DBUS REG
updated 2001-12-19 according to Q4_MPEG_MISC specification
***************************************************/
#define Q4_MISC_dr_mode_w				0x1FF0
#define Q4_MISC_dr_length_w				0x1FF1
#define Q4_MISC_dr_address_w			0x1FF2
#define Q4_MISC_sbox_mode 				0x1FF3
#define Q4_MISC_dw_mode					0x1FF4
#define Q4_MISC_dw_length				0x1FF5
#define Q4_MISC_dw_address				0x1FF6
#define Q4_MISC_reset0					0x1FF8
#define Q4_MISC_reset1					0x1FF9
#define Q4_MISC_interrupt				0x1FFA
#define Q4_MISC_timer_div				0x1FFB
#define Q4_MISC_timer_count				0x1FFC
#define Q4_MISC_sbox_read_ctrl			0x1FFD
#define Q4_MISC_sbox_write_ctrl			0x1FFE


/***************************************************
JASPER/QUASAR4 MPEG_MISC				DBUS REG
updated 2001-12-20 according to Q4_MPEG_MISC specification
***************************************************/
#define Q4_MISC_dr_mode_w				0x1FF0




/***************************************************
DRAM CONTROLLER REG
***************************************************/
//------- Configuration registers--------------
#define Q4_DRAM_config					0x1C00 
#define Q4_DRAM_fifosize0				0x1C01 
#define Q4_DRAM_fifosize1				0x1C02 
#define Q4_DRAM_casdelay				0x1C03 
#define Q4_DRAM_pllcontrol				0x1C04 
#define Q4_DRAM_ac3_base				0x1C0A
#define Q4_DRAM_fifosize2				0x1C0B
#define Q4_DRAM_portmux					0x1C0C
//----- COMMANDs FOR DRAM CONTROLLER -----
#define	CMD_DRAM_timing					0x7
#define CMD_DRAM_refresh_period			127
#define	CMD_DRAM_drsize					0x0			// SDRAM 2MB 16 bit data //  0x1 for SDRAM 2MB 32 bit data

//----- R0 CHANNEL -----
#define Q4_R0_control					0x1C50  
#define Q4_R0_addlo						0x1C51
#define Q4_R0_addhi						0x1C52
#define Q4_R0_xcnt						0x1C53
#define Q4_R0_xcnt_reload				0x1C54
#define Q4_R0_xcnt_skip					0x1C55
#define Q4_R0_ycnt						0x1C56
#define Q4_R0_ycnt_reload				0x1C57
#define Q4_R0_addreload_lo				0x1C58
#define Q4_R0_addreload_hi				0x1C59
#define Q4_R0_zcnt						0x1C5A

//----- W4 CHANNEL -----
#define Q4_W4_control					0x1CF0  
#define Q4_W4_addlo						0x1CF1
#define Q4_W4_addhi						0x1CF2
#define Q4_W4_xcnt						0x1CF3
#define Q4_W4_xcnt_reload				0x1CF4
#define Q4_W4_xcnt_skip					0x1CF5
#define Q4_W4_ycnt						0x1CF6
#define Q4_W4_ycnt_reload				0x1CF7
#define Q4_W4_ycnt_skip_lo				0x1CF8
#define Q4_W4_ycnt_skip_hi				0x1CF9
#define Q4_W4_zcnt						0x1CFA

