/* asm-armnommu/arch-jasper/time.h
 *
 * Copyright 2001, Sigma Designs Inc.
 *
 * Changelog:
 *  13-12-2001 FG Created
 *
 */

#ifndef __ASM_ARCH_TIME_H__
#define __ASM_ARCH_TIME_H__

#include <asm/arch/hardware.h>

/* return cpu_clock / unit */
/* unit = 1 => cpu clock in Hz */
/* unit = 2 => sys clock in Hz */
/* unit = 1000000 => cpu clock in MHz (=tick of cpu clock per usec) */
/* etc... */
/* unit affect the precision of the PLL input clock value used (see formula below)*/



#define TICK_PER_USEC   __get_clock(1000) // this is the cpu freq in Khz = 2 * timer input clock
#define CLOCK_PRESCALE 16 // Divide by 16 the input clock
#define TIMER_PERIOD 1000/HZ // in ms 

#define TIMER_RELOAD (TICK_PER_USEC * TIMER_PERIOD) / ( 2 * CLOCK_PRESCALE    )

extern struct irqaction timer_irq;
extern void jasper_timer_interrupt(int irq, void *dev_id, struct pt_regs *regs);

static inline void setup_timer(void)
{
	char *timer_base = (char *)JASPER_TIMER_BASE;

	*(unsigned long *)(timer_base+TIMER_TMR0LOAD) = TIMER_RELOAD;
	*(unsigned long *)(timer_base+TIMER_TMR0CTL) = TIMER_COUNT_ENABLE | TIMER_PERIODIC_MODE | TIMER_PRESCALE_16;

	printk("setup_timer: Timer value = %ld\n",TIMER_RELOAD);
	timer_irq.handler = jasper_timer_interrupt;
	setup_arm_irq(TIMER0_IRQ,&timer_irq);
	
}

#endif /* __ASM_ARCH_TIME_H__ */
