/*
 *  linux/include/asm-arm/arch-mambo/hardware.h
 *
 *  This file contains the hardware definitions for Mambo.
 *
 */

#ifndef __ASM_ARCH_HARDWARE_H
#define __ASM_ARCH_HARDWARE_H

/* macro to get at IO space when running virtually */
/*  but we are not here... */
#define IO_ADDRESS(x) (x)

#define MAMBO_CPU_BASE             0x00500000	 /*  CPU block base address (on GBUS) */
#define MAMBO_HOST_BASE            0x00600000	 /*  HOST block base address */

#define MAMBO_CT_BASE              MAMBO_CPU_BASE + 0xC500 /*  Counter/Timers */
#define MAMBO_IC_BASE              MAMBO_CPU_BASE + 0xE000 /*  Interrupt Controller */
#define MAMBO_RTC_BASE             MAMBO_CPU_BASE + 0xC800 /*  Real Time Clock */
#define MAMBO_UART0_BASE           MAMBO_CPU_BASE + 0xC100 /*  UART 0 */

//#define MAMBO_UART1_BASE           0x17000000	 /*  UART 1 */
//#define MAMBO_KBD_BASE             0x18000000	 /*  Keyboard */
//#define MAMBO_MOUSE_BASE           0x19000000	 /*  Mouse */

#define MAMBO_IDE_BASE             MAMBO_HOST_BASE + 0x0400 /* IDE registers */

/* ------------------------------------------------------------------------
 *  Mambo Interrupt Controllers
 * ------------------------------------------------------------------------
 *
 *  Offsets from interrupt controller base
 *
 */
#define IRQ_STATUS                      0x00
#define IRQ_RAW_STATUS                  0x04
#define IRQ_ENABLE                      0x08
#define IRQ_ENABLE_SET                  0x08
#define IRQ_ENABLE_CLEAR                0x0C

#define INT_SOFT_SET                    0x10
#define INT_SOFT_CLEAR                  0x14

#define FIQ_STATUS                      0x20
#define FIQ_RAW_STATUS                  0x24
#define FIQ_ENABLE                      0x28
#define FIQ_ENABLE_SET                  0x28
#define FIQ_ENABLE_CLEAR                0x2C


/*
 *  Timer definitions
 *
 *  Only use timer 1 & 2
 *  (both run at 24MHz and will need the clock divider set to 16).
 *
 *  Timer 0 runs at bus frequency and therefore could vary and currently
 *  uHAL can't handle that.
 *
 */

#define MAMBO_TIMER0_BASE          MAMBO_CT_BASE
#define MAMBO_TIMER1_BASE          (MAMBO_CT_BASE + 0x100)
// #define MAMBO_TIMER2_BASE          (INTEGRATOR_CT_BASE + 0x200)

#define MAX_TIMER                       1
#define MAX_PERIOD                      621377
#define TICKS_PER_uSEC                  27  // 27 Mhz input clk

/*
 *  These are useconds NOT ticks.
 *
 */
#define mSEC_1                          1000
#define mSEC_5                          (mSEC_1 * 5)
#define mSEC_10                         (mSEC_1 * 10)
#define mSEC_25                         (mSEC_1 * 25)
#define SEC_1                           (mSEC_1 * 1000)


// JASPER UART Definition

#define UART_NR 1
#define JASPER_UART0_BASE MAMBO_UART0_BASE
#define JASPER_UART1_BASE 0


/* IDE Registers */

#define IDE_PRI_DATA            0x00
#define IDE_PRI_DEVICE_CONTROL  0x38

#endif

