/*
 *  linux/include/asm-arm/arch-mambo/irqs.h
 */

/*
 *  IRQ numbers are almost the same than ARM Integrator
 */

#define IRQ_SOFTINT                     0
#define IRQ_UARTINT0                    1
#define IRQ_UARTINT1                    2
#define IRQ_KMIINT0                     3
#define IRQ_KMIINT1                     4
#define IRQ_TIMERINT0                   5
#define IRQ_TIMERINT1                   6
#define IRQ_TIMERINT2                   7
#define IRQ_RTCINT                      8
#define IRQ_IDE                         9  // EXPINT0
#define IRQ_EXPINT1                     10
#define IRQ_EXPINT2                     11
#define IRQ_EXPINT3                     12
#define IRQ_PCIINTA                     13
#define IRQ_PCIINTB                     14
#define IRQ_PCIINTC                     15
#define IRQ_PCIINTD                     16
#define IRQ_V3INT                       17
#define IRQ_CPINT0                      18
#define IRQ_CPINT1                      19
#define IRQ_LBUSTIMEOUT                 20
#define IRQ_EXTERNAL                    21

#define MAXIRQNUM                       21

#define IRQMASK_SOFTINT                 (1 << IRQ_SOFTINT)
#define IRQMASK_UARTINT0                (1 << IRQ_UARTINT0)
#define IRQMASK_UARTINT1                (1 << IRQ_UARTINT1)
#define IRQMASK_KMIINT0                 (1 << IRQ_KMIINT0)
#define IRQMASK_KMIINT1                 (1 << IRQ_KMIINT1)
#define IRQMASK_TIMERINT0               (1 << IRQ_TIMERINT0)
#define IRQMASK_TIMERINT1               (1 << IRQ_TIMERINT1)
#define IRQMASK_TIMERINT2               (1 << IRQ_TIMERINT2)
#define IRQMASK_RTCINT                  (1 << IRQ_RTCINT)
#define IRQMASK_EXPINT0                 (1 << IRQ_EXPINT0)
#define IRQMASK_EXPINT1                 (1 << IRQ_EXPINT1)
#define IRQMASK_EXPINT2                 (1 << IRQ_EXPINT2)
#define IRQMASK_EXPINT3                 (1 << IRQ_EXPINT3)
#define IRQMASK_PCIINT0                 (1 << IRQ_PCIINT0)
#define IRQMASK_PCIINT1                 (1 << IRQ_PCIINT1)
#define IRQMASK_PCIINT2                 (1 << IRQ_PCIINT2)
#define IRQMASK_PCIINT3                 (1 << IRQ_PCIINT3)
#define IRQMASK_V3INT                   (1 << IRQ_V3INT)
#define IRQMASK_CPINT0                  (1 << IRQ_CPINT0)
#define IRQMASK_CPINT1                  (1 << IRQ_CPINT1)
#define IRQMASK_LBUSTIMEOUT             (1 << IRQ_LBUSTIMEOUT)
#define IRQMASK_APCINT                  (1 << IRQ_APCINT)

#define VALID_IRQ_MASK                  (1 << (MAXIRQNUM + 1) - 1)

/*
 *  FIQ interrupts definitions are the same the INT definitions.
 */

 /* NOT USED - FIXME
#define FIQ_SOFTINT                     IRQ_SOFTINT
#define FIQ_UARTINT0                    IRQ_UARTINT0
#define FIQ_UARTINT1                    IRQ_UARTINT1
#define FIQ_KMIINT0                     IRQ_KMIINT0
#define FIQ_KMIINT1                     IRQ_KMIINT1
#define FIQ_TIMERINT0                   IRQ_TIMERINT0
#define FIQ_TIMERINT1                   IRQ_TIMERINT1
#define FIQ_TIMERINT2                   IRQ_TIMERINT2
#define FIQ_RTCINT                      IRQ_RTCINT
#define FIQ_IDE                         IRQ_IDE
#define FIQ_EXPINT1                     IRQ_EXPINT1
#define FIQ_EXPINT2                     IRQ_EXPINT2
#define FIQ_EXPINT3                     IRQ_EXPINT3
#define FIQ_PCIINT0                     IRQ_PCIINT0
#define FIQ_PCIINT1                     IRQ_PCIINT1
#define FIQ_PCIINT2                     IRQ_PCIINT2
#define FIQ_PCIINT3                     IRQ_PCIINT3
#define FIQ_V3INT                       IRQ_V3INT
#define FIQ_CPINT0                      IRQ_CPINT0
#define FIQ_CPINT1                      IRQ_CPINT1
#define FIQ_LBUSTIMEOUT                 IRQ_LBUSTIMEOUT
#define FIQ_APCINT                      IRQ_APCINT

#define FIQMASK_SOFTINT                 (1 << IRQ_SOFTINT)
#define FIQMASK_UARTINT0                (1 << IRQ_UARTINT0)
#define FIQMASK_UARTINT1                (1 << IRQ_UARTINT1)
#define FIQMASK_KMIINT0                 (1 << IRQ_KMIINT0)
#define FIQMASK_KMIINT1                 (1 << IRQ_KMIINT1)
#define FIQMASK_TIMERINT0               (1 << IRQ_TIMERINT0)
#define FIQMASK_TIMERINT1               (1 << IRQ_TIMERINT1)
#define FIQMASK_TIMERINT2               (1 << IRQ_TIMERINT2)
#define FIQMASK_RTCINT                  (1 << IRQ_RTCINT)
#define FIQMASK_IDE                     (1 << IRQ_IDE)
#define FIQMASK_EXPINT1                 (1 << IRQ_EXPINT1)
#define FIQMASK_EXPINT2                 (1 << IRQ_EXPINT2)
#define FIQMASK_EXPINT3                 (1 << IRQ_EXPINT3)
#define FIQMASK_PCIINT0                 (1 << IRQ_PCIINT0)
#define FIQMASK_PCIINT1                 (1 << IRQ_PCIINT1)
#define FIQMASK_PCIINT2                 (1 << IRQ_PCIINT2)
#define FIQMASK_PCIINT3                 (1 << IRQ_PCIINT3)
#define FIQMASK_V3INT                   (1 << IRQ_V3INT)
#define FIQMASK_CPINT0                  (1 << IRQ_CPINT0)
#define FIQMASK_CPINT1                  (1 << IRQ_CPINT1)
#define FIQMASK_LBUSTIMEOUT             (1 << IRQ_LBUSTIMEOUT)
#define FIQMASK_APCINT                  (1 << IRQ_APCINT)
*/

/*
 *  Misc. interrupt definitions
 */
#define IRQ_KEYBDINT                    IRQ_KMIINT0
#define IRQ_MOUSEINT                    IRQ_KMIINT1

// JASPER UART definition
#define JASPER_UART0_IRQ IRQ_UARTINT0
#define JASPER_UART1_IRQ IRQ_UARTINT1


#define IRQMASK_KEYBDINT                (1 << IRQ_KMIINT0)
#define IRQMASK_MOUSEINT                (1 << IRQ_KMIINT1)

#define NR_IRQS                         (MAXIRQNUM + 1)

