/*
 *  linux/include/asm-arm/hardware/serial_jasper.h
 *
 *  Internal header file for JASPER serial ports
 *
 *  Copyright (C) ARM Limited
 *  Copyright (C) 2000 Deep Blue Solutions Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef ASM_ARM_HARDWARE_SERIAL_JASPER_H
#define ASM_ARM_HARDWARE_SERIAL_JASPER_H

/* -------------------------------------------------------------------------------
 *  From JASPER UART Block Specification
 * -------------------------------------------------------------------------------
 *  UART Register Offsets.
 */

#define JASPER_UART_RBR                    0x00 /*  Receive Buffer Register. (Read)*/
#define JASPER_UART_TBR                    0x04 /*  Transmit Buffer Register (Write). */
#define JASPER_UART_IER                    0x08 /*  Interrupt Enable Register. */
#define JASPER_UART_IIR                    0x0C /*  Interrupt Identification Register (Read). */
#define JASPER_UART_FCR                    0x10 /*  Fifo Control Register. */
#define JASPER_UART_LCR                    0x14 /*  Line Control register. */
#define JASPER_UART_MCR                    0x18 /*  Modem Control Register. */
#define JASPER_UART_LSR                    0x1C /*  Line Status register (Read). */
#define JASPER_UART_MSR                    0x20 /*  Modem Status register (Read). */
#define JASPER_UART_SCRATCH                0x24 /*  Scratch register. */
#define JASPER_UART_CLKDIV                 0x28 /*  Clock divisor register. */
#define JASPER_UART_CLKSEL                 0x2C /*  Clock selector register. */


#define JASPER_UART_IER_ERBFI              0x1
#define JASPER_UART_IER_ETBEI              0x2
#define JASPER_UART_IER_ELSI               0x4
#define JASPER_UART_IER_EDSSI              0x8

#define JASPER_UART_LSR_DR                 0x01
#define JASPER_UART_LSR_OE                 0x02
#define JASPER_UART_LSR_PE                 0x04
#define JASPER_UART_LSR_FE                 0x08
#define JASPER_UART_LSR_BI                 0x10
#define JASPER_UART_LSR_THRE               0x20
#define JASPER_UART_LSR_TEMT               0x40
#define JASPER_UART_LSR_RXFE               0x80
/* FIXME: here the LSR_ANY flag match the RSR_ANY flag in serial_amba.h
   ie ANY = BI + OE + PE +FE */
#define JASPER_UART_LSR_ANY                0x1E

#define JASPER_UART_MSR_DCTS               0x01
#define JASPER_UART_MSR_DDSR               0x02
#define JASPER_UART_MSR_TERI               0x04
#define JASPER_UART_MSR_DDCD               0x08
#define JASPER_UART_MSR_CTS                0x10
#define JASPER_UART_MSR_DSR                0x20
#define JASPER_UART_MSR_RI                 0x40
#define JASPER_UART_MSR_DCD                0x80

#define JASPER_UART_MCR_DTR                0x01
#define JASPER_UART_MCR_RTS                0x02


// IIR register

#define UART_INT_PENDING                   0x1
// INTID
#define UART_INT_MODEM                     0x0
#define UART_INT_TX_EMPTY                  0x1
#define UART_INT_RX_DATA                   0x2
//#define UART_INT_(Line status)                  0x3
#define UART_INT_RX_TIMEOUT                0x6

#define JASPER_UART_LCR_WLS               0x03
#define JASPER_UART_LCR_WLEN_5            0x00
#define JASPER_UART_LCR_WLEN_6            0x01
#define JASPER_UART_LCR_WLEN_7            0x02
#define JASPER_UART_LCR_WLEN_8            0x03
#define JASPER_UART_LCR_STP2              0x04
#define JASPER_UART_LCR_PEN               0x08
#define JASPER_UART_LCR_EPS               0x10
#define JASPER_UART_LCR_FORCEPAR          0x20
#define JASPER_UART_LCR_SETBRK            0x40

#define JASPER_UART_FCR_FIFOENA           0x01
#define JASPER_UART_FCR_RXRST             0x02
#define JASPER_UART_FCR_TXRST             0x04

#define JASPER_BAUD_460800                 1
#define JASPER_BAUD_230400                 3
#define JASPER_BAUD_115200                 7
#define JASPER_BAUD_57600                  15
#define JASPER_BAUD_38400                  23
#define JASPER_BAUD_19200                  47
#define JASPER_BAUD_14400                  63
#define JASPER_BAUD_9600                   95
#define JASPER_BAUD_4800                   191
#define JASPER_BAUD_2400                   383
#define JASPER_BAUD_1200                   767

#endif
